 ; Ŀ
 ;   Adat - add an attribute to a block.                                   
 ;   Copyright 1995, 2006, 2008, 2010 by Rocket Software Ltd.              
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Abat: add a new attribute above or below an existing one.  
 ;   Takes no arguments.                                                   
 ;   Calls Sacc.                                                           
 ;   Returns a list:                                                       
 ;   (Block_ename  New_att_ename  Old_att_position  New_att_is_up_or_down) 
 ; 
 (DEFUN ABAT (/ enam nent entt pa blenam blent blins blang atpos atang diff
                                                        dira incr angg typ)
 ; Ŀ
 ;   Get a base attribute.                                                 
 ; 
  (setq enam (car (setq nent (nentsel "Base Attribute: "))))
  (setq entt (entget enam))
  (setq pa (spit entt))
 ; Ŀ
 ;   No attempt is made to deal with nested blocks                         
 ;   since that would be dumb.                                             
 ; 
  (if (= (type (caar (reverse nent))) 'ename)
      (progn
           (write-line "That Wasn't An Attribute.")
           (exit)))
 ; Ŀ
 ;   Get the parent block data.  Nentseling an attribute doesn't return    
 ;   a nesting list since technically attributes aren't nested.            
 ; 
  (setq blenam (cdr (assoc 330 (entget enam))))
  (setq blent (entget blenam))
  (setq blins (cdr (assoc 10 blent)))
  (setq blang (cdr (assoc 50 blent)))
 ; Ŀ
 ;   Get the position of the attribute in the block.                       
 ; 
  (setq atpos (foap blenam enam))
 ; Ŀ
 ;   Get the parent block to attribute angle.                              
 ;   Set the up or down flag.                                              
 ; 
  (setq atang (angle blins pa))
  (setq diff (- atang blang))
  (if (and (> diff 0) (< diff pi))
      (setq dira "up")
      (setq dira "down"))
 ; Ŀ
 ;   Get an angle and distance to the insertion point for the new att.     
 ; 
  (setq incr (* 1.65 (cdr (assoc 40 entt))))
  (if (= dira "up")
      (setq angg (+ (/ pi 2) (cdr (assoc 50 entt))))
      (setq angg (+ (* pi 1.5) (cdr (assoc 50 entt)))))
 ; Ŀ
 ;   If the entity was an attribute or text then make a new one as text.   
 ; 
  (setq typ (cdr (assoc 0 entt)))
  (if (member typ '("ATTRIB" "TEXT"))
      (setq enam (sacc entt)))
 ; Ŀ
 ;   Reposition the new entity.                                            
 ; 
  (command ".move" enam "" "0,0" (polar '(0 0) angg incr))
 (list blenam enam atpos dira))
 ; Ŀ
 ;   Subroutine Abat end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Chab - the reblocker.                                      
 ;   Arguments: Datlst, the master data list.                              
 ;              Elist, the list of entities to use.                        
 ;              Attlst, the list of attribute values.                      
 ;              Reins, Insert the new block, T or nil.                     
 ;   Calls nothing, returns an entity name.                                
 ; 
 (DEFUN CHAB (datlst elist attlst reins / namm xscl yscl zscl rota pa elayy
                                             ss sub layy esav enam entt tag)
 ; Ŀ
 ;   Extract the required data from the master data list datlst.           
 ;   Datlst: (Block_name Xscale  Yscale  Zscale  Rotation                  
 ;            Att_value_list_old  Insertion_point  Layer)                  
 ; 
  (setq namm (nth 0 datlst))
  (setq xscl (nth 1 datlst))
  (setq yscl (nth 2 datlst))
  (setq zscl (nth 3 datlst))
  (setq rota (nth 4 datlst))
  (setq pa (nth 6 datlst))
  (setq elayy (nth 7 datlst))
 ; Ŀ
 ;   Make the list of entities to block into an ss.                        
 ; 
  (setq ss (ssadd))
  (while (setq sub (car elist))
         (setq elist (cdr elist))
         (ssadd sub ss))
 ; Ŀ
 ;   Make the block.                                                       
 ;   The next line was changed so that the reblock didn't crash under R14. 
 ;   Does AutoCAD now not prompt to overwrite during a program?            
 ;   Later: some versions crash, some don't.  This seems likely to be      
 ;   a system variable thing - expert?                                     
 ; 
  (if (< (getvar "expert") 2)
      (command ".block" namm "Y" pa ss "")
      (command ".block" namm pa ss ""))
 ; Ŀ
 ;   If Reins is T then insert the new block.                              
 ; 
  (if reins
      (progn
 ; Ŀ
 ;   Save some settings.                                                   
 ; 
           (setq layy (getvar "clayer"))
           (setvar "clayer" elayy)
           (setvar "attdia" 0)
 ; Ŀ
 ;   Insert the block, put the attributes back in.                         
 ; 
           (command ".insert" namm pa "xyz" xscl yscl zscl rota)
 ; Ŀ
 ;   Fill the attributes with spaces - not all attributes are prompted     
 ;   for on insertion, so it is safer to put them in directly.             
 ; 
           (while (= 1 (getvar "cmdactive")) (command "")) 
 ; Ŀ
 ;   Reset various sysvars.                                                
 ; 
           (setvar "attdia" 1)
           (setvar "clayer" layy)
 ; Ŀ
 ;   Apply the attribute values from attlst.                               
 ; 
           (setq esav (setq enam (entlast)))
           (while (and (setq enam (entnext enam))
                       (/= "SEQEND" (cdr (assoc 0 (setq entt (entget enam)))))
                       (setq tag (car attlst)))
                  (setq attlst (cdr attlst))
                  (entmod (subst (cons 1 tag) (assoc 1 entt) entt)))
           (entupd esav)))
 (princ))
 ; Ŀ
 ;   Subroutine Chab end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Chat - the dismantler.                                     
 ;   Argument: Exxp, the entity to explode.                                
 ;   Calls nothing, returns a data list.                                   
 ; 
 (DEFUN CHAT (exxp / exx ttyp sixsix xscl yscl zscl rota elayy pa enam entt
                                                                attlst namm)
  (setq exx (setq ttyp (entget exxp)))
 ; Ŀ
 ;   Get the entity type.                                                  
 ; 
  (setq ttyp (cdr (assoc 0 ttyp)))
 ; Ŀ
 ;   See if there are subentities.                                         
 ; 
  (setq sixsix (assoc 66 exx))
 ; Ŀ
 ;   Get X, Y, and Z scales, assume 1 if not present.                      
 ; 
  (if (setq xscl (assoc 41 exx))
      (progn
           (setq exx (subst (cons 41 1) xscl exx))
           (setq xscl (cdr xscl)))
      (setq xscl 1))
  (if (setq yscl (assoc 42 exx))
      (progn
           (setq exx (subst (cons 42 1) yscl exx))
           (setq yscl (cdr yscl)))
      (setq yscl 1))
  (if (setq zscl (assoc 43 exx))
      (progn
           (setq exx (subst (cons 43 1) zscl exx))
           (setq zscl (cdr zscl)))
      (setq zscl 1))
 ; Ŀ
 ;   Get rotation angle, assume 0 if not present.                          
 ; 
  (if (setq rota (assoc 50 exx))
      (progn
           (setq exx (subst (cons 50 0) rota exx))
           (setq rota (cdr rota))
           (setq rota (* rota (/ 180 pi))))
      (setq rota 0))
 ; Ŀ
 ;   If the block was scaled or rotated, fix this before exploding it.     
 ;   Note that this should be applied to the new attdef too, but isn't.    
 ; 
  (if (or (/= xscl 1) (/= yscl 1) (/= zscl 1) (/= rota 0))
      (entmod exx))
 ; Ŀ
 ;   Save the layer the block was inserted on.                             
 ; 
  (setq elayy (cdr (assoc 8 exx)))
 ; Ŀ
 ;   Get the block insertion point.                                        
 ;   Note that the routine Chat allows one to explode a polyline, but      
 ;   this version is strictly for blocks.                                  
 ; 
  (setq pa (cdr (assoc 10 exx)))
 ; Ŀ
 ;   If it's a block and there are subentities (attributes) then step      
 ;   through them and save the values.                                     
 ; 
  (setq enam exxp)
  (if (and (= ttyp "INSERT") sixsix)
      (while (/= (cdr (assoc 0 (setq entt (entget (setq enam
                                                  (entnext enam)))))) "SEQEND")
             (setq attlst (append attlst (list (cdr (assoc 1 entt)))))))
 ; Ŀ
 ;   If it's a block insert get the block name and explode it.             
 ;   If it wasn't we shouldn't be here...                                  
 ; 
  (if (= ttyp "INSERT")
      (progn
           (setq namm (cdr (assoc 2 (entget exxp))))
           (command ".explode" exxp)))
 ; Ŀ
 ;   Return a data list.                                                   
 ; 
 (list namm xscl yscl zscl rota attlst pa elayy))
 ; Ŀ
 ;   Subroutine Chat end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Foap: find the position of an attribute in a block.        
 ;   Arguments: Enam, the block insertion ename.                           
 ;              Attnam, the attribute ename.                               
 ;   Calls nothing, returns a zero based position.                         
 ; 
 (DEFUN FOAP (enam attnam / num fini)
  (setq num 0)
  (while (and (null fini)
             (/= "SEQEND" (cdr (assoc 0 (entget (setq enam (entnext enam)))))))
         (if (equal attnam enam)
             (setq fini num))
             (setq num (1+ num)))
 fini)
 ; Ŀ
 ;   Subroutine Foap end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Sacc - copy an attribute.                                  
 ; 
 (DEFUN SACC (entt / bbf nn sublst asonum enam)
  (setq bbf (list (cons 0 "ATTDEF")))
  (setq nn 0)
  (while (setq sublst (nth nn entt))
         (setq nn (1+ nn))
         (setq asonum (car sublst))
         (cond ((and (= 8 asonum) (= (cdr sublst) "0"))
                (setq bbf (cons (cons 8 "TEXT") bbf)))
               ((= asonum 2)
                (setq bbf (cons sublst bbf))
                (setq bbf (cons (cons 3 (cdr sublst)) bbf)))
               ((not (or (= -1 asonum)
                         (= 0 asonum)
                         (= 5 asonum)
                         (= 62 asonum)    ; colour should be bylayer (none)
                         (= 73 asonum)
                         (= 100 asonum)
                         (= 330 asonum)
                         (= 280 asonum))) ; attribute position lock flag
                (setq bbf (cons sublst bbf)))))
  (setq bbf (reverse bbf))
 ; Ŀ
 ;   Make the new entity, if this works then return its entity name.       
 ;   If entmake works it returns the data list given to it (else nil),     
 ;   not the data list for the new entity, so must get the new entity      
 ;   name with (entlast).                                                  
 ; 
  (setq enam (if (entmake bbf) (entlast)))
 enam)
 ; Ŀ
 ;   Sacc end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Smak - make a list of any entities after a given one.      
 ;   Takes the marker ename as an argument, returns a list.                
 ;   Note: this routine looks overly baroque.                              
 ; 
 (DEFUN SMAK (aaa / liss bbb)
  (setq liss (list (setq bbb (entnext aaa))))
 ; Ŀ
 ;   If the entity is an insert and there are attributes:                  
 ; 
  (if (and (= (cdr (assoc 0 (entget bbb))) "INSERT")
           (= (cdr (assoc 66 (entget bbb))) 1))
 ; Ŀ
 ;   Then find the seqend before assuming entnext will give the next ent.  
 ; 
      (progn
           (while (/= (cdr (assoc 0 (entget bbb))) "SEQEND")
                  (setq bbb (entnext bbb)))))
 ; Ŀ
 ;   Find all entities after the marker point, put them in an ss.          
 ; 
  (while (entnext bbb)                          ; while there are entities
         (setq bbb (entnext bbb))               ; find the next new entity
         (setq liss (append liss (list bbb)))   ; add it to the list
         (if (and (= (cdr (assoc 0 (entget bbb))) "INSERT")
                  (= (cdr (assoc 66 (entget bbb))) 1))
             (progn
                  (while (/= (cdr (assoc 0 (entget bbb))) "SEQEND")
                         (setq bbb (entnext bbb))))))
 liss)
 ; Ŀ
 ;   Smak end.                                                             
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (setq yjust (cdr (assoc 73 entt)))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Tget - get a string by keyboard entry or entity selection at the      
 ;   same prompt.                                                          
 ;   Takes no arguments, but uses the global variable pstr.                
 ;   Returns a string or nil.                                              
 ;   Calls nothing.                                                        
 ; 
 (DEFUN TGET (/ ppstr goon aa pa)
  (if (= (type pstr) 'STR)
      (prompt (strcat "\nEnter Text or Select an Example (<Return> = "
                       pstr "): "))
      (prompt "\nEnter Text or Select an Example: "))
 ; Ŀ
 ;   Use grread to get points so can also accept keyboard input.           
 ; 
  (setq ppstr "")
  (setq goon t)
  (while (and goon (setq aa (grread () 4 2)))
         (cond ((= (car aa) 3)                             ; a point
                (setq goon ())                             ; leave loop
                (setq pa (cadr aa)))                       ; save point
               ((equal aa (list 2 13))                     ; Keyboard <Return>
                (setq goon ()))                            ; leave looop
               ((equal (car aa) 25)                        ; Mouse <Return>
                (setq goon ()))                            ; leave looop
               ((equal aa (list 6 0))                      ; Digitizer <Return>
                (setq goon ()))                            ; leave looop
               ((equal aa (list 2 2))                      ; F9
                (setvar "snapmode" (abs (1- (getvar "snapmode")))))
               ((equal aa (list 2 15))                     ; F8
                (setvar "orthomode" (abs (1- (getvar "orthomode")))))
               ((equal (car aa) 2)                         ; a keypress
                (setq ppstr (strcat ppstr (setq aa (chr (cadr aa)))))
                (princ aa))))
  (if pa
      (progn
           (if (/= ppstr "") (prompt "\nPoint override."))
           (if (setq ppstr (nentselp pa))
               (if (= (type (caar (reverse ppstr))) 'ENAME)
                   (setq pstr (cdr (assoc 1 (entget (caar (reverse ppstr))))))
                   (setq pstr (cdr (assoc 1 (entget (car ppstr))))))
              (setq pstr ())))
      (if (/= ppstr "") (setq pstr ppstr)))
 pstr)
 ; Ŀ
 ;   Tget end.                                                             
 ; 

 ; Ŀ
 ;   Adat.                                                                 
 ; 
 (DEFUN C:ADAT (/ snapp *error* enam blenam dira atpos esav datlst atvals
                                       liss liss0 atnum sub gnulis num vala)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "snapmode" snapp)
   (command ".undo" "end")
   (if enam (redraw enam 4))
   (if shk (write-line shk))
  (princ))
 ; Ŀ
 ;   Get an attribute in a block, make and position a new attribute.       
 ; 
  (setq enam (abat))
  (setq blenam (car enam))             ; block ename
  (setq dira (cadddr enam))            ; new att is up or down from picked one
  (setq atpos (caddr enam))            ; attribute position in block
  (setq esav (setq enam (cadr enam)))  ; new attdef ename
 ; Ŀ
 ;   Call Chat to explode the block and return datlst:                     
 ;   (Block_name  Xscale  Yscale  Zscale  Rotation  Att_value_list         
 ;    Insertion_point  Layer)                                              
 ; 
  (setq datlst (chat blenam))
  (setq atvals (nth 5 datlst))
 ; Ŀ
 ;   Call Smak to get a list of the entities from the exploded block.      
 ; 
  (setq liss (smak enam))
  (setq liss0 liss)      ; save a copy before adding the new attdef
 ; Ŀ
 ;   Add the new attdef to the list, either before or after the one from   
 ;   which it was copied, depending on the up/down flag dira.              
 ; 
  (setq atnum -1)
  (while (setq sub (car liss))
         (setq liss (cdr liss))
         (if (= (cdr (assoc 0 (entget sub))) "ATTDEF")
             (progn
                  (setq atnum (1+ atnum))
                  (if (= atnum atpos)
                      (if (= dira "up")
                          (progn
                               (setq gnulis (cons enam gnulis))
                               (setq gnulis (cons sub gnulis)))
                          (progn
                               (setq gnulis (cons sub gnulis))
                               (setq gnulis (cons enam gnulis))))
                      (setq gnulis (cons sub gnulis))))
             (setq gnulis (cons sub gnulis))))
  (setq liss (reverse gnulis))
 ; Ŀ
 ;   Add a placeholder string to the attribute value list.                 
 ; 
  (setq gnulis ())
  (setq num 0)
  (while (setq vala (nth num atvals))
         (setq num (1+ num))
         (if (/= (1- num) atpos)
             (setq gnulis (cons vala gnulis))
             (if (= dira "up")
                 (progn
                      (setq gnulis (cons "-" gnulis))
                      (setq gnulis (cons vala gnulis)))
                 (progn
                      (setq gnulis (cons vala gnulis))
                      (setq gnulis (cons "-" gnulis))))))
  (setq atvals (reverse gnulis))
 ; Ŀ
 ;   Call Chab to put everything back together: Time 1.                    
 ; 
  (setq blenam (chab datlst liss atvals t))
 ; Ŀ
 ;   Recover the entities that were used to make the block.                
 ; 
  (command ".oops")
 ; Ŀ
 ;   Erase the new attribute.                                              
 ; 
  (entdel esav)
 ; Ŀ
 ;   Reassemble the rest into a new block but don't insert it.             
 ; 
  (chab datlst liss0 nil nil)
 ; Ŀ
 ;   Offer to put a new text string into the attribute.                    
 ; 
;  (setq pstr (cdr (assoc 1 entt)))
;  (redraw enam 3)
;  (if (setq gnustr (tget))
;      (progn
;           (setq entt (entget enam))
;           (entmod (subst (cons 1 gnustr) (assoc 1 entt) entt)))
;      (redraw enam 4))


 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* nil)
 (princ))